﻿using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.CellWalkers
{
    /// <summary>
    /// Class wrapping a cell walker and applying limit to number of walked cells.
    /// </summary>
    class LimitedStepsCellWalker
    {
        /// <summary>
        /// Limit of number of walked cells.
        /// </summary>
        private int max;

        /// <summary>
        /// Current number of remaining walked cells 
        /// </summary>
        protected int i;

        /// <summary>
        /// Cell walker which is wrapped by this class.
        /// </summary>
        private CellWalker cellWalker;

        /// <summary>
        /// Number of cells already walked.
        /// </summary>
        internal int CellsWalked { get { return max - i; } }

        /// <summary>
        /// Constructor of cell walker with limited number of walked cells.
        /// </summary>
        /// <param name="cellWalker">Cell walker to be wrapped.</param>
        /// <param name="max">Maximum number of walked cells.</param>
        internal LimitedStepsCellWalker(CellWalker cellWalker, int max)
        {
            this.cellWalker = cellWalker;
            this.i = this.max = max;
        }

        /// <summary>
        /// Get walked cells whose number is at most 'max'.
        /// </summary>
        /// <returns>Walked cells.</returns>
        internal virtual IEnumerable<Cell> GetNext()
        {
            foreach (Cell cell in cellWalker.GetNext())
                if (i-- > 0 && cell.Sensor == null)
                    yield return cell;
                else
                    yield break;
        }
    }
}
